## Document Processor elements

*documentprocessor* elements are contained in [docproc chain elements](https://docs.vespa.ai/en/reference/services-docproc.html#chain) or in the *document-processing* root.

A documentprocessor element is either a document processor definition or document processor reference. The rest of this section deals with document processor definitions; document processor references are described in [docproc chain elements](https://docs.vespa.ai/en/reference/services-docproc.html#docproc-chain-elements).

A documentprocessor definition causes the creation of exactly one document processor instance. This instance is set up according to the content of the documentprocessor element.

A documentprocessor definition contained in a docproc chain element defines an *inner document processor* . Otherwise, it defines an *outer document processor.*

For inner documentprocessors, the name must be unique inside the docproc chain. For outer documentprocessors, the component id must be unique. An inner documentprocessor is not permitted to have the same name as an outer documentprocessor.

Optional sub-elements:

* provides, a single name that should be added to the provides list
* before, a single name that should be added to the before list
* after, a single name that should be added to the after list
* config (one or more)

For more information on provides, before and after, see [Chained components](https://docs.vespa.ai/en/components/chained-components.html).

| Attribute | Required | Value | Default |                                                                                   Description                                                                                   |
|-----------|----------|-------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| class     |          |       |         |                                                                                                                                                                                 |
| bundle    |          |       |         |                                                                                                                                                                                 |
| id        | required |       |         | The component id of the documentprocessor instance.                                                                                                                             |
| idref     |          |       |         |                                                                                                                                                                                 |
| provides  | optional |       |         | A space-separated list of names that represents what this documentprocessor produces.                                                                                           |
| before    | optional |       |         | A space-separated list of phase or provided names. Phases or documentprocessors providing these names will be placed later in the docproc chain than this document processor.   |
| after     | optional |       |         | A space-separated list of phase or provided names. Phases or documentprocessors providing these names will be placed earlier in the docproc chain than this document processor. |

### documentprocessor

Defines a documentprocessor instance of a user specified class.

```
<documentprocessor id="componentId"
                   class="className:versionSpecification"
                   bundle="the name in <artifactId> in pom.xml">
    ...
</documentprocessor>
```

| Attribute | Required | Value | Default |                                                                                 Description                                                                                 |
|-----------|----------|-------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| id        | required |       |         | The component id of the documentprocessor instance.                                                                                                                         |
| class     | optional |       |         | A component specification containing the name of the class to instantiate to create the document processor instance. If missing, copied from id.                            |
| bundle    | optional |       |         | The bundle containing the class: The name in \<artifactId\> in pom.xml. If a bundle is not specified, the bundle containing document processors bundled with Vespa is used. |

[Read more](https://docs.vespa.ai/en/reference/services-docproc.html#document-processor-elements)
